/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.comm;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.comm.PortNotAvailableException;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.IOException;
import java.util.Enumeration;

public class SerialPortDataTransfer
extends DataTransfer {
    private static final int TELEGRAM_BUFFER_SIZE = 8192;
    SerialPort fPort = null;
    final int MODEM_TIMEOUT = 5000;
    private boolean fTestDelay = false;
    public static boolean fTestModem = false;
    private String fPortName;

    public static DataTransfer openConnection(String portName, boolean showError, boolean ignoreDevice) throws ExceptionAlreadyHandledException {
        DataTransfer dt = null;
        if (Modem.isModemConnected()) {
            dt = Modem.getInstance().getDataTransfer();
            dt.addProgressListener(null);
            dt.setHardware(null);
        }
        if (dt == null) {
            dt = SerialPortDataTransfer.getPortByName(portName, showError, true);
        }
        dt.setShowErrorDialog(showError);
        try {
            if (!ignoreDevice) {
                dt.reConnect();
            }
        }
        catch (Exception e) {
            if (cPort != null) {
                cPort.closePort();
            }
            throw new ExceptionAlreadyHandledException();
        }
        return dt;
    }

    public static DataTransfer getPortByName(String portName, boolean showError, boolean allowRetry) throws ExceptionAlreadyHandledException {
        SerialPortDataTransfer dt = null;
        try {
            dt = new SerialPortDataTransfer(portName);
        }
        catch (PortNotAvailableException pnae) {
            if (showError) {
                if (allowRetry) {
                    LogoError.checkRepeatTransmission(new TransmissionFailedException(176));
                } else {
                    Object[] arr = new String[]{portName};
                    new LogoError(null, "error.com.noPort", "Can not open the interface.", arr, 0, 0).display();
                }
            }
            throw new ExceptionAlreadyHandledException();
        }
        return dt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SerialPortDataTransfer(String portName) throws PortNotAvailableException {
        this.fPortName = portName;
        CommPortIdentifier comIdent = null;
        Enumeration k = CommPortIdentifier.getPortIdentifiers();
        if (cPort != null && cPort != null) {
            System.err.println("Close opened port.");
            cPort.closePort();
        }
        while (k.hasMoreElements()) {
            CommPortIdentifier pIdent = (CommPortIdentifier)k.nextElement();
            if (!pIdent.getName().equals(this.fPortName)) continue;
            comIdent = pIdent;
            break;
        }
        if (comIdent == null) throw new PortNotAvailableException();
        try {
            this.fPort = (SerialPort)comIdent.open(this.fPortName, 1000);
            this.fPort.setSerialPortParams(9600, 8, 1, 2);
            this.fPort.disableReceiveThreshold();
            this.fPort.enableReceiveTimeout(15);
            this.fPort.setInputBufferSize(8192);
            this.setStreams();
            this.fPort.setRTS(true);
            this.fPort.setDTR(true);
            if (this.fDebugGeneral) {
                System.out.println("fPort opened: " + this.fPortName);
            }
        }
        catch (Exception e) {
            this.fPort = null;
            this.fInputStream = null;
            this.fOutputStream = null;
            throw new PortNotAvailableException();
        }
        cPort = this;
    }

    private void setStreams() throws IOException {
        if (!this.fTestDelay) {
            this.fInputStream = this.fPort.getInputStream();
            this.fOutputStream = this.fPort.getOutputStream();
        } else {
            this.fInputStream = new Modem.DelayInputStream(this.fPort.getInputStream());
            this.fOutputStream = new Modem.DelayOutputStream(this.fPort.getOutputStream());
        }
    }

    public void closePort() {
        if (Modem.isModemConnected()) {
            if (Modem.getInstance().getDataTransfer() == this) {
                return;
            }
            System.err.println("Assert false, forget disconnect");
        }
        if (this.fPort != null) {
            if (this.fDebugGeneral) {
                System.out.println("fport closed: " + this.portName());
            }
            this.fPort.close();
            this.fPort = null;
            cPort = null;
        } else if (cPort != null) {
            System.err.println("DataTransfer: Singleton violation");
        }
    }

    private String portName() {
        if (this.fPort != null) {
            return this.fPort.getName();
        }
        return "";
    }

    protected int getTimeoutRead(int estimatedTimeout) {
        int timeout = estimatedTimeout;
        if (Modem.isModemConnected()) {
            timeout += 5000;
        }
        return timeout;
    }

    protected void resetInternalWait() {
        if (Modem.isModemConnected()) {
            try {
                if (this.fDebugGeneral) {
                    System.out.println("Wait for a while to empty buffer");
                }
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resetInternal();
    }

    protected int getReadByteRetryTimes() {
        return Modem.isModemConnected() ? 5 : 10;
    }

    protected int[] readBytes(int adr, int count) throws TransmissionFailedException {
        if (Modem.isModemConnected()) {
            return this.readBytesViaModem(adr, count);
        }
        return super.readBytes(adr, count);
    }

    protected int[] readBytesViaModem(int adr, int count) throws TransmissionFailedException {
        int BLOCK_LEN = 1024;
        int[] retValue = new int[count];
        for (int i = 0; i < count; i += 1024) {
            int thisTimeCount = Math.min(1024, count - i);
            int[] tmp = this.readBytesViaModem1(adr + i, thisTimeCount);
            System.arraycopy(tmp, 0, retValue, i, thisTimeCount);
        }
        return retValue;
    }

    private int[] readBytesViaModem1(int adr, int count) throws TransmissionFailedException {
        int retryTime = 0;
        while (true) {
            try {
                int[] tmp = super.readBytes(adr, count);
                return tmp;
            }
            catch (TransmissionFailedException tfe) {
                if (tfe.getError() == 3 && retryTime < 5) {
                    if (this.getHardware() instanceof Logo) {
                        ((Logo)this.getHardware()).clearPasswordOnLogo(this);
                    }
                    ++retryTime;
                    continue;
                }
                throw tfe;
            }
            break;
        }
    }

    public String toString() {
        return Language.getString("msg.com.TransferVia", "Transfer via ") + this.fPort.getName();
    }

    protected boolean isCheckPointOfWritingBytes(int index) {
        return index > 0 && (index & 0xF) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rebuildConnection() throws ExceptionAlreadyHandledException {
        try {
            this.closePort();
            CommPortIdentifier comIdent = null;
            Enumeration k = CommPortIdentifier.getPortIdentifiers();
            while (k.hasMoreElements()) {
                CommPortIdentifier pIdent = (CommPortIdentifier)k.nextElement();
                if (!pIdent.getName().equals(this.fPortName)) continue;
                comIdent = pIdent;
                break;
            }
            if (comIdent == null) throw new PortNotAvailableException();
            try {
                this.fPort = (SerialPort)comIdent.open(this.fPortName, 1000);
                this.fPort.setSerialPortParams(9600, 8, 1, 2);
                this.fPort.disableReceiveThreshold();
                this.fPort.enableReceiveTimeout(15);
                this.fPort.setInputBufferSize(8192);
                this.setStreams();
                this.fPort.setRTS(true);
                this.fPort.setDTR(true);
                if (this.fDebugGeneral) {
                    System.out.println("fPort opened: " + this.fPortName);
                }
            }
            catch (Exception e) {
                this.fPort = null;
                this.fInputStream = null;
                this.fOutputStream = null;
                throw new PortNotAvailableException();
            }
            cPort = this;
            return;
        }
        catch (PortNotAvailableException pnae) {
            Object[] arr = new String[]{this.fPortName};
            new LogoError(null, "error.com.noPort", "Can not open the interface.", arr, 0, 0).display();
        }
    }
}

